/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vpd;

import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.base.vpd.VpdErrorIds;
import com.ibm.hwmca.base.vpd.VpdTasks;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;

public class RebuildVpdTasklet
extends PanelTasklet
implements VpdErrorIds,
CommonMsgInterface {
    private static final String TRACE_MASKT = "HCONRVTT";
    private static final String TRACE_MASKF = "HCONRVTF";
    private static final String TRACE_MASKD = "HCONRVTD";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(97, "RebuildVpdTasklet");

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        block9: {
            Trace.trace(TRACE_MASKT, "-> RebuildVpdTasklet.service()");
            try {
                if (taskletRequest.isInitialRequest()) {
                    BaseMessageTitle title = new BaseMessageTitle("RVPD8001");
                    MessageText[] messageText = new BaseMessageText[]{new BaseMessageText("RVPDCONF")};
                    LocalizableText[] options = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON, CommonMsgInterface.HELP_BUTTON};
                    LocalizableText buttonPressed = this.showMessageBox(false, title, messageText, messageText[0].getMsgId(), messageText[0].getMsgType(), options);
                    if (buttonPressed.equals(CommonMsgInterface.OK_BUTTON)) {
                        this.showBusyDialog(new LocalizableText(BaseTextBundle.getBundleName(), "vpd.rebuild.busy.title"), new LocalizableText(BaseTextBundle.getBundleName(), "vpd.rebuild.busy.text"));
                        try {
                            VpdTasks vpdTasks = new VpdTasks();
                            vpdTasks.rebuildVpd();
                            if (vpdTasks.partialVpd) {
                                Trace.trace(TRACE_MASKF, "Display message 'Rebuild VPD was partially successful'");
                                messageText[0] = new BaseMessageText("RVPDPARTIAL");
                            } else {
                                Trace.trace(TRACE_MASKF, "Display message 'Rebuild VPD successful Completion'");
                                messageText[0] = new BaseMessageText("RVPDGOOD");
                            }
                        }
                        catch (HException hExc) {
                            Trace.trace(TRACE_MASKF, "Display message 'Rebuild VPD failed'");
                            messageText[0] = new BaseMessageText("RVPDPROB");
                        }
                        this.destroyBusyDialog();
                        LocalizableText[] msgOptions = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
                        BaseMessageTitle resultTitle = new BaseMessageTitle("RVPD8002");
                        this.showMessageBox(false, resultTitle, messageText, messageText[0].getMsgId(), messageText[0].getMsgType(), msgOptions);
                        taskletResponse.terminate();
                        break block9;
                    }
                    taskletResponse.terminate();
                    break block9;
                }
                taskletResponse.terminate();
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "Exception during service: " + e);
                e.printStackTrace();
                new FrameworkLog(logInfo, 30979, e).log();
                if (e instanceof TaskletException) {
                    throw (TaskletException)e;
                }
                throw new TaskletException(e);
            }
        }
        Trace.trace(TRACE_MASKT, "<- RebuildVpdTasklet.service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> RebuildVpdTasklet.logException()");
        new FrameworkLog(logInfo, 30978, throwable).log();
        Trace.trace(TRACE_MASKT, "<- RebuildVpdTasklet.logException()");
    }
}

